// $Id: toc.js 5124 2007-05-03 20:21:38Z psztoch $
// Copyright (C) 2007 FINN Sp. z o.o. Wszelkie prawa zastrzezone.

var fdocSearchActive = false;
if ((new RegExp("^http:|^https:")).test(location.href)) {
	fdocSearchActive = true;
}

function fdocGetParentVariable(variable) {
	if (parent) {
		var query = parent.location.search.substring(1);
		var vars = query.split("&");
		for (var i=0;i<vars.length;i++) {
			var pair = vars[i].split("=");
			if (pair[0] == variable) {
				return pair[1];
			}
		}
	}
}

function fdocGetParent2Variable(variable) {
	if (parent) {
		if (parent.parent) {
			var query = parent.parent.location.search.substring(1);
			var vars = query.split("&");
			for (var i=0;i<vars.length;i++) {
				var pair = vars[i].split("=");
				if (pair[0] == variable) {
					return pair[1];
				}
			}
		}
	}
}

function fdocOpenMedia(nazwa) {
    var sw=screen.width, sh=screen.height;
    var ww=980, wh=700;
    var wl=parseInt((sw>ww+10?(sw-ww-10)/2:0));
    var wt=parseInt((sh>wh+70?(sh-wh-70)/2:0));
    window.open(nazwa+'.htm', 'media_'+nazwa.replace(/\//g,'_'),"width="+ww+",height="+wh+",left="+wl+",top="+wt+",toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,titlebar=yes");
}

function fdocTreeAction(objLi,e) {
	if (!e) { e = window.event; }
	if (e.target) { var trg = e.target; }
	else if (e.srcElement) { var trg = e.srcElement; }
	if (objLi) {
		var objDiv = objLi.getElementsByTagName("div")[0];
		var objUl = objLi.getElementsByTagName("ul")[0]
		if (trg == objDiv || trg == objDiv.getElementsByTagName("img")[0]) {
			if (objUl) {
				if (objLi.className.substr(1) == "p") {
					objLi.className = objLi.className.substr(0,1) + "m";
				} else if (objLi.className.substr(1) == "m") {
					objLi.className = objLi.className.substr(0,1) + "p";
				}
			}
		}
	}
}

function onTocLoad(base, tocURI, start) {
	if (parent && parent.parent && parent.parent.contentFrame) {
		var doc = fdocGetParent2Variable("doc");
		var docChapter;
		if (doc) {
			docChapter = fdocGetParent2Variable("docChapter");
		} else if (start) {
			doc = start;
		}
		if (doc) {
			if (doc.charAt(0)=='/') {
				doc = base + doc.substring(1);
			}
			parent.parent.contentFrame.location.href=doc+".html"+(docChapter?"#anchor."+docChapter:"");
		}
	} else if (base && tocURI) {
		location.href=base+'res/framework/help/index.html?toc='+tocURI;
	}
}

function onTocPanelLoad() {
	var toc = fdocGetParentVariable('toc');
	if (toc) {
		tocFrame.location.href="../../../"+toc+".html";
	}
}

function onSearchPanelLoad() {
	if (!fdocSearchActive) {
		searchFrame.location.href = "searchDisabled.html";
	}
}

function onSearchToolbarLoad() {
	document.forms["fdocSearchForm"].fdocSearchString.focus();
}

function fdocMaximizeLeft() {
	var p = parent;
	while (p && !p.toggleFrame) { p = p.parent; }
	if (p!=null) { p.toggleFrame("left"); }
	document.selection.clear;
}

function fdocMaximizeRight() {
	var p = parent;
	while (p && !p.toggleFrame) { p = p.parent; }
	if (p!=null) { p.toggleFrame("right"); }
	document.selection.clear;
}

function fdocSubmitSearch() {
	var thisPageName = "res/framework/help/searchToolbar.html";
	var prefix;
	var pos1 = location.href.indexOf("//");
	var pos2 = location.href.length-thisPageName.length
	if (pos1!=-1 && location.href.substring(pos2)==thisPageName) {
		pos1 = location.href.indexOf("/", pos1+2);
		if (pos1!=-1) {
			prefix = location.href.substring(pos1, pos2);
		}
	}
	var toc = fdocGetParent2Variable('toc');
	if (!fdocSearchActive || !prefix || !toc || parent.searchFrame==undefined) {
		alert("Mechanizm szukania w treści nie jest dostępny!");
		return;
	}
	var searchString = document.forms["fdocSearchForm"].fdocSearchString.value;
	if (!searchString || searchString == "")
		return;

	var servletBase;
	if (prefix.indexOf("/kursy/")==0) {
		servletBase = "/";
	} else {
		servletBase = "../../../";
	}
	parent.searchFrame.location.href=servletBase+"fdocSearchServlet?prefix="+prefix+"&toc="+toc+"&searchString="+encodeURIComponent(searchString);
}

function doHighlight(bodyText, searchTerm, highlightStartTag, highlightEndTag, mode) {
	var newText = "";
	var i = -1;
	var lcSearchTerm = searchTerm.toLowerCase();
	var lcBodyText = bodyText.toLowerCase();
	var success = false;

	while (bodyText.length > 0) {
		i = lcBodyText.indexOf(lcSearchTerm, i+1);
		if (i < 0) {
			newText += bodyText;
			bodyText = "";
		} else {
			success = true;
			// skip anything inside an HTML tag
			if (bodyText.lastIndexOf(">", i) >= bodyText.lastIndexOf("<", i)) {
				// skip anything inside a <script> block
				if (lcBodyText.lastIndexOf("/script>", i) >= lcBodyText.lastIndexOf("<script", i)) {
					newText += bodyText.substring(0, i) + highlightStartTag + bodyText.substr(i, searchTerm.length) + highlightEndTag;
					bodyText = bodyText.substr(i + searchTerm.length);
					lcBodyText = bodyText.toLowerCase();
					i = -1;
				}
			}
		}
	}
	if (mode || success) {
		return newText;
	}
	return null;
}

function highlightSearchTerms(target, searchText) {
	var searchArray = searchText.split(" ");
	if (!target || typeof(target.innerHTML) == "undefined") {
		return false;
	}
	var bodyText;
	bodyText = doHighlight(target.innerHTML, searchText, "<span style='font-family: inherit; font-size: inherit; background-color: yellow;'>", "</span>", false);
	if (bodyText != null) {
		target.innerHTML = bodyText;
		return true;
	}
	bodyText = target.innerHTML;
	for (var i = 0; i < searchArray.length; i++) {
		bodyText = doHighlight(bodyText, searchArray[i], "<span style='font-family: inherit; font-size: inherit; background-color: pink;'>", "</span>", true);
	}
	target.innerHTML = bodyText;
	return true;
}

function fdocUpdateTitle() {
	var newTitle;
	newTitle = this.document.title;
	if (parent && parent.parent && parent.parent.leftPanelFrame) {
		if (parent.parent.leftPanelFrame.tocFrame && parent.parent.leftPanelFrame.tocFrame.document.title != newTitle) {
			newTitle += ' - ' + parent.parent.leftPanelFrame.tocFrame.document.title;
		}
	}
	if (parent && parent.parent) {
		parent.parent.document.title = newTitle;
	}
}

function fdocOnDocumentLoad() {
	var searchString;
	if (parent && parent.parent && parent.parent.leftPanelFrame) {
		if (parent.parent.leftPanelFrame.searchToolbarFrame && parent.parent.leftPanelFrame.searchToolbarFrame.document.forms["fdocSearchForm"]) {
			searchString = parent.parent.leftPanelFrame.searchToolbarFrame.document.forms["fdocSearchForm"].fdocSearchString.value;
		}
	}
	if (searchString && 0 < searchString.length) {
		highlightSearchTerms(document.body, searchString);
	}
}

// vim:ai:ts=4 shiftwidth=4 noexpandtab encoding=utf8
